// BMFlip
// bmflip.cpp

// includes
#include "c4d.h"
#include "bmflip.h"
#include "xbmflip.h"
#include "c4d_symbols.h"

SHADERINFO BitmapFlip::GetRenderInfo(BaseShader *sh)
{
	return SHADERINFO_BUMP_SUPPORT;
}

Bool BitmapFlip::Init(GeListNode *node)
{
	shader = nullptr;
	flipX = false;
	flipY = false;
	return true;
}

void BitmapFlip::FreeRender(BaseShader *sh)
{
	if(shader)
		shader->FreeRender();
	shader = nullptr;
}

Bool BitmapFlip::Message(GeListNode *node, Int32 type, void *msgdat)
{
	BaseContainer *data;

	data = ((BaseShader*)node)->GetDataInstance();
	HandleInitialChannel(node, BMFLIPSHADER_TEXTURE, type, msgdat);
	HandleShaderMessage(node, (BaseShader*)data->GetLink(BMFLIPSHADER_TEXTURE, node->GetDocument(), Xbase), type, msgdat);

	return true;
}

INITRENDERRESULT BitmapFlip::InitRender(BaseShader *chn, const InitRenderStruct& irs)
{
	BaseContainer *data;

	data = chn->GetDataInstance();
	// get gadget values
	flipX = data->GetBool(BMFLIPSHADER_FLIPX);
	flipY = data->GetBool(BMFLIPSHADER_FLIPY);
	shader = (BaseShader*)data->GetLink(BMFLIPSHADER_TEXTURE, irs.doc, Xbase);
	if(shader != nullptr)
	{
		return shader->InitRender(irs);
	}

	return INITRENDERRESULT_OK;
}

Vector BitmapFlip::Output(BaseShader *sh, ChannelData *cd)
{
	Vector res, uv;

	if(shader == nullptr) return Vector(1.0, 0.0, 0.0);		// return red if no bitmap present

	uv = cd->p;
	if(flipX)
		cd->p.x = 1.0 - cd->p.x;
	if(flipY)
		cd->p.y = 1.0 - cd->p.y;
	res = shader->Sample(cd);
	cd->p = uv;

	return res;										// otherwise return the colour from the bitmap
}

// register the plugin
Bool RegisterBMFlip(void)
{
	String name;
	name = GeLoadString(IDS_BMFLIP);
	return RegisterShaderPlugin(ID_BMFLIP, name, 0, BitmapFlip::Alloc,"Xbmflip", 0);

}
