CONTAINER Oxchemload
{
	NAME Oxchemload;
	INCLUDE Obase;

	GROUP ID_OBJECTPROPERTIES
	{
		FILENAME CHEM_FILE { ANIM OFF; }
		BUTTON CHEM_FILE_LOAD { }

		LONG CHEM_MOL_DISPLAY { CYCLE { CHEM_MOL_DISPLAY_ALL; CHEM_MOL_DISPLAY_ATOMS; CHEM_MOL_DISPLAY_BONDS; }}
		BOOL CHEM_MOL_HYDROGENS { }

		LONG CHEM_ATOM_SIZE { CYCLE { CHEM_ATOM_SIZE_RADIUS; CHEM_ATOM_SIZE_VDW; CHEM_ATOM_SIZE_MASS; CHEM_ATOM_SIZE_ATNUMBER; CHEM_ATOM_SIZE_FIXED; }}
		REAL CHEM_FIXED_RADIUS { UNIT METER; MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		REAL CHEM_ATOM_SIZE_SCALE { UNIT REAL; MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 5.0; CUSTOMGUI REALSLIDER; }
		LONG CHEM_ATOM_SEGMENTS { MIN 3; MINSLIDER 3; MAXSLIDER 48; CUSTOMGUI LONGSLIDER; }

		BOOL CHEM_NUCLEUS { }
		REAL CHEM_NUCLEUS_SCALE { UNIT PERCENT; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }
		BOOL CHEM_XRAY { }
		REAL CHEM_MOL_SCALE { UNIT REAL; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 200.0; CUSTOMGUI REALSLIDER; }

		SEPARATOR { LINE; }
		REAL CHEM_BOND_RADIUS { UNIT METER; MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 20.0; CUSTOMGUI REALSLIDER; }
		REAL CHEM_BOND_RADIUS_SCALE_DOUBLE { UNIT REAL; MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 5.0; CUSTOMGUI REALSLIDER; }
		REAL CHEM_BOND_RADIUS_SCALE_TRIPLE { UNIT REAL; MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 5.0; CUSTOMGUI REALSLIDER; }
		LONG CHEM_BOND_IP { MIN 0; MINSLIDER 0; MAXSLIDER 8; CUSTOMGUI LONGSLIDER; }
		BOOL CHEM_BOND_CAPS { }
	}

	GROUP ID_CHEM_COLORS
	{
		LONG CHEM_COLORS_ATOMS { CYCLE { CHEM_COLORS_ATOMS_CPK; CHEM_COLORS_ATOMS_HCNO; }}
		LONG CHEM_COLORS_ATOMS_PRESETS { CYCLE { COLORS_ATOMS_PRESETS_0; COLORS_ATOMS_PRESETS_1; COLORS_ATOMS_PRESETS_2;
												 COLORS_ATOMS_PRESETS_3; COLORS_ATOMS_PRESETS_4; COLORS_ATOMS_PRESETS_5; }}
		COLOR CHEM_ATOM_PRESET_H { }
		COLOR CHEM_ATOM_PRESET_C { }
		COLOR CHEM_ATOM_PRESET_N { }
		COLOR CHEM_ATOM_PRESET_O { }
		COLOR CHEM_ATOM_PRESET_DEFAULT { }
		BUTTON CHEM_ATOM_RESTORE_PRESETS { }
		SEPARATOR CHEM_NUCLEUS_SEP1 { LINE; }
		COLOR CHEM_NUCLEUS_COLOR { }
		SEPARATOR CHEM_BOND_SEP1 { LINE; }
		COLOR CHEM_BOND_SINGLE_COLOR { }
		COLOR CHEM_BOND_DOUBLE_COLOR { }
		COLOR CHEM_BOND_TRIPLE_COLOR { }
		COLOR CHEM_BOND_AROMATIC_COLOR { }
	}

	GROUP ID_CHEM_MATS
	{
		LONG CHEM_MATLINK_NUMLINKS { MIN 0; HIDDEN; }
		GROUP ID_CHEM_MATLINKS
		{
			DEFAULT 1;
			GROUP ID_CHEM_MAT_BUTTONS
			{
				DEFAULT 1;
				COLUMNS 2;
				BUTTON CHEM_MATLINK_ADD { SCALE_H; };
				BUTTON CHEM_MATLINK_REMOVE { SCALE_H; };
			}
		}
	}
}
