// Dialog Example - dialogex.h

// plugin ID
#ifndef ID_DIALOGEX
#define ID_DIALOGEX 1000006				// non-unique ID value for test purposes only
#endif

// dialog class declaration
class DialogExample : public GeDialog	// the dialog box will be derived from the C4D GeDialog base class
{
private:
	BaseObject *op;						// pointer to the active object in the document

public:
	DialogExample(void);				// constructor
	virtual ~DialogExample(void);		// destructor
	// virtual C4D functions we should override
	virtual Bool CreateLayout(void);	// called to create the dialog box
	virtual Bool InitValues(void);		// called to initialise local variables
	virtual Bool Command(Int32 id, const BaseContainer& msg);	// called to handle user interaction
	virtual Bool AskClose(void);		// called when the dialog is closed
};

// command plugin class declaration
class MenuPlug : public CommandData		// the actual plugin class is derived from C4D's CommandData class
{
private:
	DialogExample dlg;					// an instance of the dialog class - the plugin could have multiple dialogs instantiated here

public:
	// virtual C4D functions we should override
	virtual Bool Execute(BaseDocument *doc);		// called when the user invokes the plugin from the Plugins menu
	virtual Int32 GetState(BaseDocument *doc);		// called by C4D to determine how to display the plugin name in the Plugins menu
};
