﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.Win32;
using System.IO;

namespace ProjectToolWrapper
{
    public partial class Form1 : Form
    {
        string g_projectpath = "";
        string g_toolpath = "";
        string g_pdeffile = "";

        public Form1()
        {
            InitializeComponent();
        }

        private void BtnGetToolPath_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.ShowNewFolderButton = false;
            folderBrowserDialog1.RootFolder = Environment.SpecialFolder.MyComputer;
            DialogResult result = folderBrowserDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                txtToolPath.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void BtnGetProjectPath_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.ShowNewFolderButton = false;
            folderBrowserDialog1.RootFolder = Environment.SpecialFolder.MyComputer;
            DialogResult result = folderBrowserDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                txtProjectPath.Text = folderBrowserDialog1.SelectedPath;
            }
        }
        private void BtnGetDefinitionFile_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.ShowNewFolderButton = false;
            folderBrowserDialog1.RootFolder = Environment.SpecialFolder.MyComputer;

            openFileDialog1.Filter = "Text files (*.txt)|*.txt";
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                txtDefinitionFile.Text = openFileDialog1.FileName;
            }
        }

        private void BtnRunProjectTool_Click(object sender, EventArgs e)
        {
            // start by copying the definition file selected to 'projectdefinition.txt' if there is a file in the text box and it's not the default projectdefinition.txt file
            // if it is the default file, just leave it alone and use that
            if(txtDefinitionFile.Text != "" && txtDefinitionFile.Text != "projectdefinition.txt")
            {
                string definitionFile = txtDefinitionFile.Text;
                // if the user's file exists, we need to remove the existing projectdefinition.txt and replace it with the user file
                if(File.Exists(definitionFile))
                {
                    // if the file is simply 'projectdefinition.txt' we don't need to delete it, simply run the project tool on that file
                    string defaultDefFile = Path.GetDirectoryName(definitionFile) + @"\" + @"projectdefinition.txt";
                    if (definitionFile != defaultDefFile)
                    {
                        if (File.Exists(defaultDefFile))
                        {
                            // delete the existing 'projectdefinition.txt' file
                            try
                            {
                                File.Delete(defaultDefFile);
                            }
                            catch
                            {
                                MessageBox.Show("The existing projectdefinition.txt file could not be deleted. Is it read-only or in use by another program? The project tool will not be executed.", "Failed to delete file",
                                    MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                                return;
                            }
                        }

                        // if the existing projectdefinition.txt file was successfully deleted, or there wasn't one anyway
                        // copy the selected file to a new file with the name 'projectdefinition.txt'
                        try
                        {
                            File.Copy(definitionFile, defaultDefFile, true);
                        }
                        catch
                        {
                            MessageBox.Show("A problem occurred in copying the definition file. Please check that the file exists and that its name has no invalid characters. The project tool will not be executed.", "Failed to copy file",
                                MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                            return;
                        }
                    }
                }
                else
                {
                    // if the user file doesn't exist, abort the process
                    MessageBox.Show("The specified project file cannot be found. The project tool will not be executed.", "No such file", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
            }

            if (txtProjectPath.Text != "" && txtToolPath.Text != "" && txtDefinitionFile.Text != "")
            {
                string toolPath = txtToolPath.Text + @"\kernel_app_64bit.exe";
                char ap = '\"';
                string projectPath = ap + txtProjectPath.Text + ap;
                if (File.Exists(toolPath))
                {
                    System.Diagnostics.Process process = new System.Diagnostics.Process();
                    process.StartInfo.FileName = toolPath;
                    process.StartInfo.Arguments = "g_updateproject=" + projectPath;
                    process.Start();
                    process.Close();
                }
                else
                {
                    MessageBox.Show("The Project Tool application cannot be found in the project path.", "Missing Project Tool", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                }
            }
            else
            {
                MessageBox.Show("The project definition file, the path to the Project Tool and the path to the project itself must all be provided.", "Missing path or file", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void saveOptionsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SaveConfig();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            string appPath = Path.GetDirectoryName(Application.ExecutablePath);
            string appInit = appPath + "\\projecttoolwrapper.txt";
            string sautosave = "off";
            FileStream fs = null;

            try
            {
                fs = new FileStream(appInit, FileMode.Open, FileAccess.Read);
                StreamReader txtIn = new StreamReader(fs);
                g_projectpath = txtIn.ReadLine();
                g_toolpath = txtIn.ReadLine();
                g_pdeffile = txtIn.ReadLine();
                sautosave = txtIn.ReadLine();
                if (sautosave == "off")
                    checkBoxAutoSave.Checked = false;
                else
                    checkBoxAutoSave.Checked = true;
                txtProjectPath.Text = g_projectpath;
                txtToolPath.Text = g_toolpath;
                txtDefinitionFile.Text = g_pdeffile;
                txtIn.Close();
            }
            catch(FileNotFoundException)
            {
                txtProjectPath.Text = "";
                txtToolPath.Text = "";
                txtDefinitionFile.Text = "";
                checkBoxAutoSave.Checked = false;
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (checkBoxAutoSave.Checked == true)
                SaveConfig();
        }

        private void BtnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void BtnSaveConfig_Click(object sender, EventArgs e)
        {
            SaveConfig();
        }

        private void SaveConfig()
        {
            string appPath = Path.GetDirectoryName(Application.ExecutablePath);
            string appInit = appPath + "\\projecttoolwrapper.txt";
            FileStream fs = null;

            if (txtProjectPath.Text != "")
                g_projectpath = txtProjectPath.Text;
            if (txtToolPath.Text != "")
                g_toolpath = txtToolPath.Text;
            if (txtDefinitionFile.Text != "")
                g_pdeffile = txtDefinitionFile.Text;
            try
            {
                fs = new FileStream(appInit, FileMode.Create, FileAccess.Write);
                StreamWriter txtOut = new StreamWriter(fs);
                txtOut.WriteLine(g_projectpath);
                txtOut.WriteLine(g_toolpath);
                txtOut.WriteLine(g_pdeffile);
                if (checkBoxAutoSave.Checked == false)
                    txtOut.WriteLine("off");
                else
                    txtOut.WriteLine("on");
                txtOut.Close();
            }
            catch (FileNotFoundException)
            {
                MessageBox.Show("Unable to save the configuration file.\n\nPlease check write permissions for the folder where this application is located.");
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
        }

        private void aboutProjectToolGUIToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Project Tool GUI v1.2\n\nCopyright (c) Microbion 2022\n\nReleased under the GNU General Public License v3");
        }

        private void label3_Click(object sender, EventArgs e)
        {

        }

        private void txtToolPath_TextChanged(object sender, EventArgs e)
        {

        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {

        }
    }
}
