// addcoll.cpp
// compile for R11

#include "c4d.h"
#include "c4d_symbols.h"
#include "addcoll.h"
#include "customgui_filename.h"

// dialog class implementation
AddCollDialog::AddCollDialog(void)
{
	// do nothing
}

AddCollDialog::~AddCollDialog()
{
	// destructor
	dlg_res.Free();
}

Bool AddCollDialog::CreateLayout(void)
{
	Bool res = TRUE;

	// call the base class function first
	GeDialog::CreateLayout();

	// create a resource object and initialise it to the plugin's path
	dlg_res.Init(GeGetPluginPath());
	if(res = LoadDialogResource(IDD_SIBL_ADDCOLL, &dlg_res, 0))
	{
		SetTitle("Add an sIBL collection");
		fncollec = NULL;
		fncollec = (FilenameCustomGui*)FindCustomGui(IDC_ADDCOLLPATH, 1000478);
	}
	else
		GePrint("sIBL Loader: could not load resource file for Add Collection dialog box.");

	return res;
}

Bool AddCollDialog::InitValues(void)
{
	// first call the base class function
	if(!GeDialog::InitValues()){
		return FALSE;
	}
	buttonClicked = FALSE;			// by default set to return a 'Cancel'
	return TRUE;
}

Bool AddCollDialog::Command(LONG id, const BaseContainer &msg)
{
	switch (id)
	{
	case IDC_OK:
		if(fncollec)
			newCollectionFolder = fncollec->GetData().GetValue().GetFilename();
		GetString(IDC_ADDCOLLNAME, newCollectionName);
		if(newCollectionFolder.GetString() == "" || newCollectionName == "")
		{
			MessageDialog("Please enter a path to an sIBL collection folder, and give the collection a name.");
			buttonClicked = FALSE;
			return FALSE;
		}
		else
		{
			buttonClicked = TRUE;
			Close(TRUE);
			return TRUE;
		}
		break;

	default:
		buttonClicked = FALSE;
		return FALSE;
		break;
	}
}

