// iniread.h
// class to open and manipulate an ini-format file

class IniRead
{
public:
	IniRead(void);													// default constructor
	~IniRead(void);													// destructor

	String leftTrim(String str);									// left-trim spaces from a string
	String rightTrim(String str);									// right-trim spaces from a string
	String allTrim(String str);										// trim all leading and trailing spaces from a string
	String getKey(String str);										// get a key name from a line
	String getValue(String str);									// get a value (as string) from a line
	String removeQuotes(String str);								// remove double-quotes from the beginning and end of a line
	LONG compareNoCase(String str1, String str2);					// compares two string case-insensitively
};
