// sIBLLoader - main.cpp

#include "c4d.h"
#include "bmflip.h"

// forward declarations
Bool RegisterSIBL(void);
C4D_CrashHandler old_handler;

void SDKCrashHandler(CHAR* crashinfo)
{
	// don't forget to call the original handler!!!
	if (old_handler) (*old_handler)(crashinfo);
}

Bool PluginStart(void)
{
	Bool success;

	// example of installing a crashhandler
	old_handler = C4DOS.CrashHandler;		// get the original handler (must be called!)
	C4DOS.CrashHandler = SDKCrashHandler;	// insert own handler

	GePrint(" ");
	GePrint("--------- Microbion Software ---------");
	if(!RegisterSIBL())
	{
		GePrint("Failed to register sIBL Loader");
		success = FALSE;
	} else {
		GePrint("sIBL Loader successfully loaded.");
		success = TRUE;
	}
	if(RegisterBMFlip())
	{
		GePrint("sIBL Bitmap Transform shader loaded.");
		success = TRUE;
	}
	else
	{
		GePrint("Failed to register sIBL Bitmap Transform shader.");
		success = FALSE;
	}
	GePrint(" ");
	return success;
}

void PluginEnd(void)
{
	// nothing to do
	return;
}

Bool PluginMessage(LONG id, void *data)
{
	// handle incoming messages
	switch (id)
	{
	case C4DPL_INIT_SYS:
		if(!resource.Init())
		{
			return FALSE;					// don't start plugin without its resource
		}
		else
		{
			return TRUE;
		}
		break;

	case C4DMSG_PRIORITY:
		return TRUE;
		break;

	default:
		return FALSE;
	}
}
