// sibl.h
// compile for R11

// plugin ID
#ifndef ID_SIBLLOADER
#define ID_SIBLLOADER 1025128
#endif

#ifndef _VPbase_H_
#define ID_VIDEOPOSTPROPERTIES 1000994
#endif

#include "customgui_hyperlink.h"
#include "customgui_filename.h"
#include "iniread.h"
#include "version.h"
#include "addcoll.h"
#include "preview.h"

// defines
#define SIBL_PREFS_SIBLEDITPATH 1205
#define SIBL_PREFS_MAXCOLLECTIONS 1206
#define SIBL_PREFS_NUMCOLLECTIONS 1207
#define SIBL_PREFS_CURRENTCOLLECTION 1208
#define SIBL_PREFS_LOADALL 1209
#define SIBL_PREFS_USESPHERES 1210
#define SIBL_PREFS_SPHERERADIUS 1215
#define SIBL_PREFS_AUTOSAVEPREFS 1220
#define SIBL_PREFS_TEXPREVIEWSIZE 1225
#define SIBL_PREFS_WARNNOMATCHES 1230
#define SIBL_PREFS_CORRECTSUN 1232
#define SIBL_PREFS_USEVRAY 1235
#define SIBL_PREFS_VRAYBGWARNING 1236
#define SIBL_PREFS_VRAYADDREFRACTION 1237
#define SIBL_PREFS_WARNONCLEAR 1238
#define SIBL_PREFS_DEFAULTCOLLECTION 1239
#define SIBL_PREFS_COLLECTPATH 1250
#define SIBL_PREFS_VRAY_AUTODISABLESUN 1260
#define SIBL_PREFS_LS_SCALEMULTI 1270

#define SIBL_GUI_BITBUTTON 5000

// sky object types
#define SIBL_SKY_BG 5100
#define SIBL_SKY_EN 5101
#define SIBL_SKY_RE 5102

// other values
#define SECONDS_PER_HALF_DAY 43200
#define DEFAULT_MAX_COLLECTIONS 25

// render engines
#define ADV_RENDER 0
#define VRAY_RENDER 1

// light types
#define SPOTLIGHT 0
#define OMNILIGHT 1

// Lightsmith shapes
#define LS_SQUARE 0
#define LS_CIRCULAR 1

// Lightsmith objects
#define LS_ILLUM 0
#define LS_FRAME 1

// Vray values
//#define VP_VRAYBRIDGE_GI_ON 1050
#define VPvray 1019782
#define Vlighttag 1020441
#define Vcomptag 1021738
#define VRAY_LWF_NOCHANGE 0
#define VRAY_LWF_OFF 1
#define VRAY_LWF_8BIT 2
#define VRAY_LWF_32BIT 3
#define VRAY_LS_MODE_LUM 0
#define VRAY_LS_MODE_DI 1
#define VRAY_LS_MODE_MESH 2

// filter shader
#ifndef Xslafilter
#define Xslafilter 1011128
#endif

// BMFlip sahder
#ifndef Xbmflip
#define Xbmflip 1025517
#endif

// Videoposts
#define SIBL_DEGAMMA 1024272
#define VP_COLORMAPPING 1001194
#define VP_COLORCORRECT 1001008
#define ID_PV_FILTER_GAMMA 1000

// constants for the presence/activation of CM, CC, and DeGamma videoposts
#define VP_NOT_PRESENT 0
#define VP_PRESENT_INACTIVE 1
#define VP_PRESENT_ACTIVE 2

// user area derived objects
// dialog banner
class Banner : public GeUserArea
{
	BaseBitmap* bmp;
	Filename bmpToLoad;
	virtual Bool Init(void);
	virtual void DrawMsg(LONG x1, LONG y1, LONG x2, LONG y2, const BaseContainer& msg);
public:
	Banner();
	virtual ~Banner();
};

// multiline comment field
class CommentField : public GeUserArea
{
	virtual Bool Init(void);
	virtual void DrawMsg(LONG x1, LONG y1, LONG x2, LONG y2, const BaseContainer& msg);
	
public:
	String txtComment;
};

// sun color field
class SunColorField : public GeUserArea
{
	virtual Bool Init(void);
	virtual void DrawMsg(LONG x1, LONG y1, LONG x2, LONG y2, const BaseContainer& msg);
	
public:
	Vector color;
};

// structure to hold plugin options
struct dlgOptions
{
public:
	Bool loadBG;				// load background JPG
	Bool loadENV;				// load lighting HDR
	Bool loadREF;				// load reflection HDR
	Bool loadSUN;				// create the sun light
	Bool correctSun;			// if TRUE and no sun has been loaded, will search the list of extra lights for one names 'Sun' and move it into the sun light parameters
	Bool setupGI;				// turn on GI
	Bool loadLights;			// create other lights if present
	LONG lightType;				// 0 = spots, 1 = omnis
	LONG renderEngine;			// 0 = AR, 1 = Vray
	Bool alignNorth;			// align setup with Z-axis to north
	Bool useSpheres;			// use spheres instead of Sky objects
	Bool overWriteExisting;		// if an sIBL set is in use, overwrite the values if this is set, otherwise create a new one
	Bool turnOffLights;			// turn off any existing lights
	Real sphereRadius;			// radius of spheres to use instead of Sky objects
	LONG texPreview;			// the texture preview size to use
	Bool autoSavePrefs;			// if on, preferences are saved on closing the dialog
	LONG maxCollecs;			// the maximum number of collections the loader can handle
	Bool loadAll;				// if on, the plugin will load presets from all the collections in the collections array
	Bool filterOnName;			// if FALSE, filtering will be done on the comment field
	Bool filterAll;				// if TRUE, when filtering presets must match all keywords; if FALSE, can match on any keyword
	Bool warnNoMatches;			// if TRUE, show a dialog box if there are no matches after filter is applied
	Bool vrayUseGIEnv;			// if TRUE, the environment light image is loaded into the Vraybridge GI env slot instead of a dome light
	Bool vrayUseSunIntensity;	// if TRUE, the sun intensity is applied as a multiplier to standard and physical cameras
	Bool vrayEditorBGSky;		// if TRUE, a sky object for use in the editor only is created with the background applied
	Bool vrayWarnBG;			// if TRUE, a warning will be issued when the user creates a Vray editor background object
	Bool vrayAddRefraction;		// if TRUE, the reflection image (if loaded) will be added to the refraction slot as well
	LONG vrayLWFMode;			// the LWF mode, 0 = none, 1 = 8-bit (for editor), 2 = 32-bit (for render)
	Bool saveDefCollect;		// if TRUE, the current collection will be stored as the default, otherwise it is set to 0
	Bool warnOnClear;			// if TRUE, a warning will be shown if the user clicks the 'Clear preset' button
	Real ls_scalemulti;			// the default multiplier used for scaling up lightsmith objects
	LONG vrayLSMode;			// the way lightsmiths in Vray are added
	Real vrayLSIntensMulti;		// the intensity multiplier for lightsmiths in Vray
};

// data structure for non-sun lights
struct lightData
{
public:
	String lightname;				// the light name
	Vector lightcolor;				// light color
	Real lightmulti;				// light multiplier
	Real lightu;					// u position
	Real lightv;					// v position
};

struct lsData
{public:
	String lsname;				// name of this lightsmith
	String lsfile;				// the .exr file used for the luminance
	String lsmaskfile;			// alpha mask for the light emitting object
	Real lswidth;
	Real lsheight;
	Real lsareawidth;
	Real lsareaheight;
	Vector lscolor;				// color for the light emitting object
	Real lsmulti;				// multiplier for the light emission
	String lsobjectfile;		// the light emitting object
	String lsframefile;			// the frame object
	Vector lsframecolor;		// color for the frame object
	Real lsscale;				// scale
	LONG lsshape;				// the shape type
};

// data structure to hold the data read from an .ibl file
struct presetData
{
public:
	// Header
	Filename path;				// path to the set folder
	Filename file;				// the filename of the .ibl file
	String icoFile;				// thumbnail file name
	String previewFile;			// the preview file (if present)
	String name;				// preset name
	String author;				// preset author
	String location;			// shoot location
	String comment;				// preset comment
	String geoLat;				// shoot latitude
	String geoLong;				// shoot lontitude
	String link;				// URL of source
	String geoDate;				// date taken
	String geoTime;				// time taken
	Real height;				// height
	Real north;					// north
	// Background
	String bgfile;				// the background file
	LONG bgmap;					// projection type
	Real bgu;					// horizontal offset
	Real bgv;					// vertical offset
	LONG bgheight;				// height in pixels of image
	//Environment
	String evfile;				// environment map
	LONG evmap;					// projection type
	Real evu;					// horizontal offset
	Real evv;					// vertical offset
	LONG evheight;				// height in pixels of image
	Real evmulti;				// lighting multiplier
	Real evgamma;				// adjustment gamma
	// Reflection
	String reffile;				// reflection map
	LONG refmap;				// projection type
	Real refu;					// horizontal offset
	Real refv;					// vertical offset
	LONG refheight;				// height in pixels of image
	Real refmulti;				// lighting multiplier
	Real refgamma;				// adjustment gamma
	// Sun light
	Bool addsun;				// FALSE if there is no sun
	Vector suncolor;			// sunlight color
	Real sunmulti;				// sun multiplier
	Real sunu;					// sun horizontal position
	Real sunv;					// sun vertical position
	// Multilights
	LONG numlights;				// number of lights (other than sun)
	lightData* lights;			// pointer to the data for the lights
	// Lightsmiths
	LONG numLS;					// number of Lightsmith structures
	lsData* ls;					// pointer to the data for the Lightsmiths
	// end of preset data
};

// vray GI settings
struct vraySetData
{
public:
	Bool lwfHistory;			// if TRUE, the previous preset was applied using LWF; if FALSE, it was applied without LWF (or no preset has been applied yet)
	LONG type;					// color mapping type
	LONG lwfOn;					// turn on LWF
	Real burn;					// color mapping burn
	Real cmgamma;				// color mapping gamma
	Real multip;				// color mapping multiplier
	Bool r12LWF;				// switch for R12's own LWF
};

// arGI settings
struct arSetData
{
public:
	Bool lwfHistory;			// if TRUE, the previous preset was applied using LWF; if FALSE, it was applied without LWF (or no preset has been applied yet)
	LONG cmType;				// whether color mapping was present or not
	LONG ccType;				// whether color correction was present or not
	LONG deType;				// whether DeGamma was present or not
	Real ccGamma;				// the color correction gamma setting
	Bool r12LWF;				// switch for R12's own LWF
};

// preset sorting class
class PresetSort : public GeSortAndSearchEx
{
public:
	virtual LONG Compare(void *a, void *b);
};

// struct to hold collection data
struct collData
{
public:
	String name;				// optional name for the collection
	Filename fname;				// the path to the collection folder
};

// struct to hold tokens for filtering
struct tokenData
{
	String tokenStr;
};

// global variables
	presetData *presets;												// pointer to preset array
	presetData *oldPresets;												// used when applying a filter to presets - holds the unfiltered presets

// dialog class declaration
class SIBLDialog : public GeDialog
{
private:
	Banner bannerUA;
	CommentField comfieldUA;
	SunColorField suncolorUA;
	AboutDialog vrs;
	AddCollDialog adcl;
	PreviewDialog prv;
	dlgOptions theOpts;
	BitmapButtonCustomGui *bbcg;										// pointer to the bitmap button for the thumbnail
	HyperLinkCustomGui *hlcg;
	FilenameCustomGui *fncollec, *fnibled;
	collData *siblCollecs;												// pointer to the list of collections
	LONG currentColl;													// index into the collection list, indicating the current collection
	LONG numColls;														// the number of collections the loader knows about
	GeResource dlg_res;													// the dialog resource
	SimpleListView lvPresets;											// the presets list view
	Filename sibleditFolder;											// Filename object points to the location of sIBL-Edit
	LONG presetCount;													// number of presets
	LONG oldPresetCount;												// used when applying a filter to presets - holds the number of unfiltered presets
	LONG presetIndex;													// index of current preset
	Bool winFlag;														// TRUE on a Windows OS, FALSE on Mac
	Bool filterFlag;													// if TRUE, the presets are being filtered
	Bool vrayFlag;														// if TRUE, Vray is available on this machine
	vraySetData vrayGIOpts;

	void ResetOpts(void);												// resets options to default values
	void GetOpts(void);													// read user options from the dialog and store them in the options structure
	void SetOpts(void);													// get the options from the options structure and set them in the dialog
	void SetupGUI(void);												// set up the dialog according to values in the options
	void ScanCollection(Bool redrawFlag);								// scan the collections folder for sIBL sets
	void ShowSetDetails(LONG index);									// display details for the set
	void SetFirstItem(void);											// set list view focus to the first item in the list
	String GetLatLong(String degrees, Bool isLat);						// formats a string to display lat/long correctly
	LONG GetPresetCount(Bool bSingle, Filename fname);					// count the number of presets for memory allocation, either for a single or multiple files
	LONG GetIBLCount(Filename folderName);								// counts the number .ibl files in a given folder
	Bool LoadPresets(Bool bSingle, Filename fname, LONG counter);		// load all the detected preset files into the allocated memory
	LONG LoadIBLSet(Filename fileToLoad, LONG index);					// load a set of presets in one collection into memory
	VLONG ReadFile(Filename fullPath, Filename file, LONG index, CHAR* buffer);			// open an .IBL file and read it all into a buffer
	Bool ReadLights(VLONG numBytes, LONG index, CHAR* buffer);							// if there are additional lights, get them here
	Bool ReadLS(VLONG numBytes, LONG index, CHAR* buffer);								// if there are Lightsmith sections, get them here
	Bool ReadLine(BaseFile *bf, String& line);							// read a string from a file
	void SetKey(String key, String value, LONG index);					// saves the key-values into the data structure
	void SetLightKey(String key, String value, LONG index, LONG lightIndex);		// as for SetKey() but for lights
	void SetLSKey(String key, String value, LONG index, LONG lsIndex);		// as for SetKey() but for lightsmiths
	void InitPreset(LONG index);										// initialises a preset to default values
	Bool SavePrefs(void);												// save the preferences
	Bool SaveCollectionsPrefs(void);									// saves only the number of collections and the filenames to the preferences
	Bool LoadPrefs(void);												// load the preferences
	Vector GetColorFromValue(String value);								// takes a string formatted as '255, 255, 255' and converts it into a color vector
	String GetDateFromValue(String aDate);								// returns a formatted date from an EXIF data string
	String GetTimeFromValue(String aTime);								// returns a formatted time from an EXIF time string
	Bool ApplyPreset(void);												// applies the current preset to the scene
	Bool ApplyPresetVray(void);											// applies the current preset using Vray
	Material* CreateSkyMat(BaseDocument *doc, String texFile, String matName, LONG skyType);		// creates a material to be applied to a Sky object
	Bool ApplySkyMat(BaseDocument *doc, Material *mat, BaseObject* skyObj);			// apply the material to the Sky object
	Bool CreateCompTag(BaseDocument *doc, BaseObject* skyObj, LONG skyType);		// creates and applies a compositing tag to each sky object
	Bool CreateSun(BaseDocument *doc, BaseObject *parent, BaseObject *prev);		// create a sun
	Bool CreateLights(BaseDocument *doc, BaseObject *parent, BaseObject *prev);		// create additional lights
	Bool CreateLS(BaseDocument *doc, BaseObject *parent, BaseObject *prev);		// create Lightsmiths
	Bool ReloadFile(void);												// re-read an .IBL file and store new values in the presets array
	void SetupGI(BaseDocument *doc);									// applies GI to the scene
	void AlignNorth(BaseDocument *doc, BaseObject *parent);				// align the scene with Z-axis pointing north
	void KillLights(BaseDocument *doc, BaseObject *obj);				// find and disable lights
	void RemoveExisting(BaseDocument *doc);								// deletes an existing set and its materials
	void DisableExisting(BaseDocument *doc, BaseObject *obj);			// disables any existing sIBL sets
	void DeleteObject(BaseDocument *doc, BaseObject *obj, Bool isRoot);				// deletes an object tree recursively
	void RemoveCollection(void);										// removes a collection from the collection list
	void ClearPresets(void);											// clears all presets from memory and leaves an empty preset list
	void ApplyFilter(Bool redrawFlag);									// filters the presets according to user-input tokens
	void RemoveFilter(Bool redrawFlag);									// remove the applied filter
	void ShowThumbs(LONG counter, String stat);							// resets the browser and preset list with the current set of presets
	void ChooseCollection(void);										// load presets for the selected collection
	Bool SetupVray(BaseDocument *doc);									// sets Vray as the render engine and loads the Vraybridge videopost
	Bool SetVrayEnv(BaseDocument *doc, LONG envType, Bool enableEnv);		// sets the background or reflection environment in Vray
	Bool CreateVrayDomeLight(BaseDocument *doc, BaseObject *parent, BaseObject *prev);				// create a Vray area light for the env HDRI
	Bool CreateVrayBGSky(BaseDocument *doc, BaseObject *parent, BaseObject *prev);					// create a background editor-only sky object
	Bool MakeVrayGroundMatte(BaseDocument *doc);						// make the linked object a ground matte
	void UpdateLayout(LONG renderEngine);								// updates the interface depending on which render engine is selected
	Bool RemovesIBL(BaseDocument *doc, LONG renderEngine);				// clears a preset from the scene - render engine dependent
	void CorrectSunlight(LONG index);											// corrects the erroneous sun implementation in som sIBL files
	void CreateLSMat(BaseDocument *doc, BaseObject *obj, LONG lstype, lsData lsD);		// create and apply materials for the lightsmith objects
	BaseTag* CreateMeshLight(BaseDocument *doc, BaseObject *obj, lsData lsd, BaseObject *parent, BaseObject *prev);				// creates an area mesh light for Vray lightsmiths
	void FreeMemory(void);												// free up memory when the dialog is closed or Cinema exits

public:
	SIBLDialog(void);													// constructor
	virtual ~SIBLDialog(void);											// destructor
	virtual Bool CreateLayout(void);									// create the dialog box
	virtual Bool InitValues(void);										// initialise local variables
	virtual Bool Command(LONG id, const BaseContainer& msg);			// handle user interaction
	virtual Bool AskClose(void);										// called when the dialog is closed
};

//command plugin declaration
class SIBLLoader : public CommandData
{
private:
	SIBLDialog dlg;

public:
	virtual Bool Execute(BaseDocument* doc);							// called when the user selects the plugin from the plugins menu
	virtual LONG GetState(BaseDocument* doc);
};
