// preview.cpp
// compile for R11

#include "c4d.h"
#include "c4d_symbols.h"
#include "version.h"
#include "preview.h"

// dialog class implementation
PreviewDialog::PreviewDialog(void)
{
	// do nothing
}

PreviewDialog::~PreviewDialog()
{
	// destructor
	dlg_res.Free();
}

Bool PreviewDialog::CreateLayout(void)
{
	Bool res = TRUE;

	// call the base class function first
	GeDialog::CreateLayout();

	// create a resource object and initialise it to the plugin's path
	dlg_res.Init(GeGetPluginPath());
	res = LoadDialogResource(IDD_SIBLPREVIEW, &dlg_res, 0);
	if(!res)
		GePrint("sIBL Loader: could not load resource file for Preview dialog box.");
	else
	{
		// try to find the bitmap button control
		bbcg = NULL;
		bbcg = (BitmapButtonCustomGui*)FindCustomGui(IDC_PREVIEW_BMP, 1000479);
		if(!bbcg)
		{
			GePrint("sIBL Loader: error in creating interface, thumbnails will not be visible!");
			res = FALSE;
		}
		else if(bbcg && previmg.Content())
			bbcg->SetImage(previmg);
		if(name.Content())
			SetTitle("Preview of " + name);
		else
			SetTitle("Preview");
	}

	return res;
}

Bool PreviewDialog::InitValues(void)
{
	// first call the base class function
	if(!GeDialog::InitValues()){
		return FALSE;
	}

	return TRUE;
}

Bool PreviewDialog::Command(LONG id, const BaseContainer &msg)
{
	switch (id)
	{
	case IDC_PREVIEW_CLOSE:
		Close(TRUE);
		return TRUE;
		break;

	default:
		return FALSE;
		break;
	}
}

void PreviewDialog::SetImageFile(Filename fn)
{
	if(GeFExist(fn, FALSE))
		previmg = fn;
	else
		previmg = Filename();
}

void PreviewDialog::SetImagename(String s)
{
	name = s;
}
