// version.cpp
// compile for R11

#include "c4d.h"
#include "c4d_symbols.h"
#include "version.h"
#include "customgui_hyperlink.h"

// dialog class implementation
AboutDialog::AboutDialog(void)
{
	// do nothing
}

AboutDialog::~AboutDialog()
{
	// destructor
	dlg_res.Free();
}

Bool AboutDialog::CreateLayout(void)
{
	Bool res = TRUE;
	HyperLinkCustomGui *hlcgmicro = NULL, *hlcgsibl = NULL;
	String linkTextMicro, labelTextMicro, linkTextsIBL, labelTextsIBL, appvers, version;
	LONG c4dversion = GetC4DVersion();

	appvers = LongToString(c4dversion).SubStr(0, 2);
	if(appvers == "12")
		version = " (for Cinema 4D R12)";
	else if(appvers == "13")
		version = " (for Cinema 4D R13)";
	else if(appvers == "14")
		version = " (for Cinema 4D R14)";

	// call the base class function first
	GeDialog::CreateLayout();

	// create a resource object and initialise it to the plugin's path
	dlg_res.Init(GeGetPluginPath());
	if(res = LoadDialogResource(IDD_SIBL_ABOUT, &dlg_res, 0))
	{
		// attach the user area
		AttachUserArea(vba, IDC_ABOUT_BANNER, USERAREA_COREMESSAGE);

		// set links
		hlcgmicro = (HyperLinkCustomGui*)FindCustomGui(IDC_MICROBION_SITE, 1009180);
		if(hlcgmicro)
		{
			linkTextMicro = "http://www.microbion.co.uk/graphics/c4d/siblloader.htm";
			labelTextMicro = "Microbion website";
			hlcgmicro->SetLinkString(&linkTextMicro, &labelTextMicro);
		}
		hlcgsibl = (HyperLinkCustomGui*)FindCustomGui(IDC_SMARTIBL_SITE, 1009180);
		if(hlcgsibl)
		{
			linkTextsIBL = "http://www.hdrlabs.com/sibl/index.html";
			labelTextsIBL = "Smart IBL overview";
			hlcgsibl->SetLinkString(&linkTextsIBL, &labelTextsIBL);
		}

		// set version number
		sibl_version = "Current version: 1.5 " + version;
		sibl_date = "June 18th 2013";
		
		SetString(IDC_ABOUT_VERSION, sibl_version);
		SetString(IDC_ABOUT_DATE, "Copyright Steve Pedler, " + sibl_date);
		SetTitle("About sIBL Loader");
	}
	else
		GePrint("sIBL Loader: could not load resource file for About box.");

	return res;
}

Bool AboutDialog::InitValues(void)
{
	// first call the base class function
	if(!GeDialog::InitValues()){
		return FALSE;
	}
	
	return TRUE;
}

Bool AboutDialog::Command(LONG id, const BaseContainer &msg)
{
	switch (id)
	{
	case IDC_ABOUT_CLOSE:
		Close(TRUE);
		return TRUE;
		break;

	default:
		return FALSE;
		break;
	}
}

// definitions for the user area object
AboutBanner::AboutBanner()
{
	// allocate bitmap
	bmp = NULL;
	bmp = BaseBitmap::Alloc();
}
AboutBanner::~AboutBanner()
{
	// free the bitmap
	BaseBitmap::Free(bmp);
}
Bool AboutBanner::Init()
{
	IMAGERESULT result;
	Filename fname;

	fname = GeGetPluginPath() + Filename("res");
	bmpToLoad.SetDirectory(fname);
	bmpToLoad.SetFile("about.tif");
	if(bmp)
	{
		result = bmp->Init(bmpToLoad);
		if(result != IMAGERESULT_OK)
		{
			GePrint("sIBL Loader: Error " + LongToString(result) + " in loading bitmap " + bmpToLoad.GetString());
		}
	}
	return TRUE;
}
void AboutBanner::DrawMsg(LONG x1, LONG y1, LONG x2, LONG y2, const BaseContainer &msg)
{
	// draw the bitmap
	if(bmp)
	{
		LONG w = GetWidth();
		LONG h = GetHeight();
		DrawBitmap(bmp, 0, 0, w, h, 0, 0, bmp->GetBw(), bmp->GetBh(), BMP_NORMALSCALED);
	}
}

